#include <iostream>
#include <algorithm>

int N, M;
int L[2000], R[2000];
int bestPotezi;

int abs(int n){
    if (n >= 0)
        return n;
    else return n * -1;
}

int abs2(int n){
    return n + n * (n < 0) * -2;
}

void backtrack(int d, int potezi){
    if (d == N){
        bestPotezi = std::min(bestPotezi, potezi);
    }
    else{
        if (d == 0){
            backtrack(d + 1, potezi);

            int distL = abs(L[d] - L[d + 1]);
            int distR = abs(R[d] - R[d + 1]);

            if (distL < distR && distL != 0){
                int temp = L[d];
                L[d] = L[d + 1];
                backtrack(d + 1, potezi + distL);
                L[d] = temp;
            }
            else if (distR != 0){
                int temp = R[d];
                R[d] = R[d + 1];
                backtrack(d + 1, potezi + distR);
                R[d] = temp;
            }
        }
        else if (d < N - 1){
            if (L[d] >= L[d - 1] && R[d] <= R[d - 1]){
                backtrack(d + 1, potezi);
            }

            int distL = abs(L[d] - L[d - 1]);
            int distR = abs(R[d] - R[d - 1]);

            if (distL < distR && distL != 0){
                int temp = L[d];
                L[d] = L[d - 1];
                backtrack(d + 1, potezi + distL);
                L[d] = temp;
            }
            else if (distR != 0){
                int temp = R[d];
                R[d] = R[d - 1];
                backtrack(d + 1, potezi + distR);
                R[d] = temp;
            }
            /*
            if (L[d] != L[d + 1] && L[d + 1] >= L[d - 1]){
                int temp = L[d];
                L[d] = L[d + 1];
                backtrack(d + 1, potezi + abs(temp - L[d + 1]));
                L[d] = temp;
            }

            if (R[d] != R[d + 1] && R[d + 1] <= R[d - 1]){
                int temp = R[d];
                R[d] = R[d + 1];
                backtrack(d + 1, potezi + abs(temp - R[d + 1]));
                R[d] = temp;
            }
            //*/
        }
        else{
            if (L[d] >= L[d - 1] && R[d] <= R[d - 1]){
                backtrack(d + 1, potezi);
            }

            int distL = abs(L[d] - L[d - 1]);
            int distR = abs(R[d] - R[d - 1]);

            if (distL < distR && distL != 0){
                int temp = L[d];
                L[d] = L[d - 1];
                backtrack(d + 1, potezi + distL);
                L[d] = temp;
            }
            else if (distR != 0){
                int temp = R[d];
                R[d] = R[d - 1];
                backtrack(d + 1, potezi + distR);
                R[d] = temp;
            }
        }
    }
}

int main(){
    std::ios_base::sync_with_stdio(false);

    std::cin >> N >> M;

    for (int i = 0; i < N; ++i) std::cin >> L[i] >> R[i];

    bestPotezi = N * M;
    backtrack(0, 0);

    std::cout << bestPotezi;
    return 0;
}